#include <stdint.h>
#include <stddef.h>

typedef void (*packet_receive_callback)(uint8_t*, size_t, void*);
typedef void (*fragment_receive_init)(size_t, void*);
typedef void (*fragment_receive_callback)(uint8_t*, size_t, int, void*);
typedef void (*frame_send_callback)(uint8_t*, size_t, void*);

typedef struct PacketIO PacketIO_t;

PacketIO_t *packetio_init(
        uint64_t mtu,
        packet_receive_callback packet_receive_callback,
        void *packet_receive_user_data,
        frame_send_callback frame_send_callback,
        void *frame_send_user_data);

PacketIO_t *packetio_init_streaming(
        uint64_t mtu,
        fragment_receive_init fragment_receive_init,
        fragment_receive_callback fragment_receive_callback,
        void *fragment_receive_user_data,
        frame_send_callback frame_send_callback,
        void *frame_send_user_data);

void packetio_frame_receive(uint8_t *frame, size_t len, PacketIO_t *packet_io);
int packetio_fragment_init(size_t max_len, PacketIO_t *packet_io);
void packetio_fragment_send(uint8_t *fragment, size_t len, PacketIO_t *packet_io);
void packetio_packet_send(uint8_t *packet, size_t len, PacketIO_t *packet_io);
