use smithay::wayland::{foreign_toplevel_list::ForeignToplevelHandle, shell::xdg::ToplevelSurface};
use wayland_protocols::ext::image_capture_source::v1::server::{
    ext_foreign_toplevel_image_capture_source_manager_v1::{
        ExtForeignToplevelImageCaptureSourceManagerV1,
        Request as ForeignToplevelCaptureSourceManagerRequest,
    },
    ext_image_capture_source_v1::{ExtImageCaptureSourceV1, Request as CaptureSourceRequest},
};
use wayland_server::{Client, Dispatch, DisplayHandle, GlobalDispatch, Resource};

use crate::app::App;

impl Dispatch<ExtImageCaptureSourceV1, ToplevelSurface> for App {
    fn request(
        _state: &mut Self,
        _client: &Client,
        _resource: &ExtImageCaptureSourceV1,
        request: <ExtImageCaptureSourceV1 as Resource>::Request,
        _data: &ToplevelSurface,
        _dhandle: &DisplayHandle,
        _data_init: &mut wayland_server::DataInit<'_, Self>,
    ) {
        match request {
            CaptureSourceRequest::Destroy => {}
            _ => unreachable!(),
        }
    }
}

impl Dispatch<ExtForeignToplevelImageCaptureSourceManagerV1, ()> for App {
    fn request(
        _state: &mut Self,
        _client: &Client,
        _resource: &ExtForeignToplevelImageCaptureSourceManagerV1,
        request: <ExtForeignToplevelImageCaptureSourceManagerV1 as Resource>::Request,
        _data: &(),
        _dhandle: &DisplayHandle,
        data_init: &mut wayland_server::DataInit<'_, Self>,
    ) {
        match request {
            ForeignToplevelCaptureSourceManagerRequest::CreateSource {
                source,
                toplevel_handle,
            } => {
                if let Some(surface) = toplevel_handle
                    .data::<ForeignToplevelHandle>()
                    .and_then(|d| d.user_data().get::<ToplevelSurface>().cloned())
                {
                    data_init.init(source, surface);
                }
            }
            ForeignToplevelCaptureSourceManagerRequest::Destroy => {}
            _ => unreachable!(),
        }
    }
}

impl GlobalDispatch<ExtForeignToplevelImageCaptureSourceManagerV1, ()> for App {
    fn bind(
        _state: &mut Self,
        _handle: &DisplayHandle,
        _client: &Client,
        resource: wayland_server::New<ExtForeignToplevelImageCaptureSourceManagerV1>,
        _global_data: &(),
        data_init: &mut wayland_server::DataInit<'_, Self>,
    ) {
        data_init.init(resource, ());
    }
}
