"use client";

import { useState } from "react";
import Toolbar from "./Toolbar";

export default function RotatorBar() {
  const [degrees, setDegrees] = useState(60);

  const turn = (event) => {
    const root = event.target.ownerDocument.documentElement;
    root.style.transform = `rotate(${degrees}deg)`;
    setDegrees(degrees + 60);
  };

  return (
    <Toolbar logo="/rotator.png">
      <button onClick={turn}>Rotate</button>
    </Toolbar>
  );
}
