"use client";

import { useState } from "react";
import Toolbar from "./Toolbar";

export default function CounterBar() {
  const [count, setCount] = useState(0);
  return (
    <Toolbar logo="/counter.png">
      <button onClick={() => setCount(count - 1)}>-</button>
      <code data-count={count}>
        &nbsp;{count}&nbsp;
      </code>
      <button onClick={() => setCount(count + 1)}>+</button>
    </Toolbar>
  );
}
