import { metadata } from "./layout";
import CounterBar from "@/components/CounterBar";
import RotatorBar from "@/components/RotatorBar";
import MarkdownBar from "@/components/MarkdownBar";
import CalcBar from "@/components/CalcBar";

export default async function Home({ searchParams }) {
  const { md } = await searchParams;
  return (
    <div className="page">
      <header>
        <CounterBar />
        <RotatorBar />
        <MarkdownBar md={md} />
        <CalcBar />
      </header>
      <main>
        <h1>{metadata.title}</h1>
        <h3>{metadata.description}</h3>
      </main>
    </div>
  );
}
