<?php

include_once 'inc/required.php';
include_once 'inc/users.php';
include_once 'inc/perms.php';
include_once 'inc/invites.php';

error_log('-------------------- INSTALLATION --------------------');

$db->exec('CREATE TABLE IF NOT EXISTS products (id INTEGER PRIMARY KEY, name TEXT, price INTEGER, qty INTEGER, art TEXT)');
$db->exec('CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY, username TEXT, password TEXT)');
$db->exec('CREATE TABLE IF NOT EXISTS perms (uid INTEGER, perm TEXT)');
$db->exec('CREATE TABLE IF NOT EXISTS invites (code TEXT)');
error_log('Tables created!');

if (count($db->select(['SELECT' => '*', 'FROM' => 'products'])) === 0) {
    add_tmp_perms('products_add');
    $db->insert('products', ['id' => 1, 'name' => 'NMAPPAV',     'price' => 100, 'qty' => 1337, 'art' => file_get_contents('art/NMAPPAV.txt')]);
    $db->insert('products', ['id' => 2, 'name' => 'WIREHAJ',     'price' => 200, 'qty' => 1337, 'art' => file_get_contents('art/WIREHAJ.txt')]);
    $db->insert('products', ['id' => 3, 'name' => 'BURPSUITVIK', 'price' => 300, 'qty' => 1337, 'art' => file_get_contents('art/BURPSUITVIK.txt')]);
    $db->insert('products', ['id' => 4, 'name' => 'KALIFJORD',   'price' => 400, 'qty' => 1337, 'art' => file_get_contents('art/KALIFJORD.txt')]);
    $db->insert('products', ['id' => 5, 'name' => 'FLÄGG',       'price' => 1,   'qty' => 0,    'art' => file_get_contents('art/FLÄGG.txt')]);
    rm_tmp_perms('products_add');
    error_log('Products added!');
}

if (!get_user_by_name('admin')) {
    $admin_pw = bin2hex(random_bytes(16));
    add_tmp_perms('users_add');
    $admin = create_user('admin', $admin_pw);
    rm_tmp_perms('users_add');
    $uid = $admin['id'];
    add_tmp_perms('perms_add');
    add_perm($uid, 'users_edit');
    add_perm($uid, 'users_delete');
    add_perm($uid, 'perms_edit');
    add_perm($uid, 'perms_delete');
    add_perm($uid, 'flag_read');
    rm_tmp_perms('perms_add');
    error_log("Admin password: $admin_pw");
}

if (count($db->select(['SELECT' => '*', 'FROM' => 'invites'])) === 0) {
    add_tmp_perms('invites_add');
    $invite_code = generate_invite();
    rm_tmp_perms('invites_add');
    error_log("Invite code: $invite_code");
}

error_log('Installed!');
error_log('------------------------------------------------------');

header('Location: /');
