<?php

include_once 'inc/required.php';
include_once 'inc/header.php';

$products = $db->select([
    'SELECT' => '*',
    'FROM' => 'products',
]);

echo '<div class="products">';
echo '<h2>Products</h2>';
foreach ($products as $product) {
    $out_of_stock = $product['qty'] === 0;
    echo '<a href="#" class="product' . ($out_of_stock ? ' out-of-stock' : '') . '">';
    echo '<h3>' . $product['name'] . '</h3>';
    echo '<div class="img">' . $product['art'] . '</div>';
    echo '<div class="meta"><div>$' . $product['price'] . '</div><div>';
    if ($out_of_stock) {
        echo 'Out of Stock';
    } else {
        echo $product['qty'] . ' in Stock';
    }
    echo '</div></div>';
    echo '</a>';
}
echo '</div>';

include_once 'inc/footer.php';
