<?php

include_once 'db.php';
include_once 'perms.php';
include_once 'utils.php';

define('USER_FIELDS', ['id', 'username', 'password']);
define('USER_FIELDS_EDITABLE', ['password']);

function get_user_by_name(string $username) {
    global $db;
    $res = $db->select([
        'SELECT' => USER_FIELDS,
        'FROM' => 'users',
        'WHERE' => ['username' => $username],
    ]);
    return count($res) > 0 ? $res[0] : null;
}

function check_user_creds(string $username, string $password) {
    global $db;
    $user = get_user_by_name($username);
    if ($user && password_verify($password, $user['password'])) {
        return $user;
    }
    return null;
}

function create_user(string $username, string $password) {
    global $db, $errors;
    if (get_user_by_name($username)) {
        $errors[] = 'Username already taken';
        return false;
    }
    $user = $db->insert('users', [
        'username' => $username,
        'password' => password_hash($password, PASSWORD_DEFAULT),
    ]);
    return $user;
}

function delete_user($uid) {
    global $db;
    $db->delete('perms', ['uid' => $uid]);
    $db->delete('users', ['id' => $uid]);
}
