<?php

include_once 'db.php';

function get_perms() {
    global $db;
    $res = $db->select([
        'SELECT' => ['perm'],
        'FROM' => 'perms',
        'WHERE' => ['uid' => $_SESSION['uid'] ?? -1],
    ]);
    return array_map(function($perm) { return $perm['perm']; }, $res);
}

function has_perms(...$perms) {
    if (!isset($_SESSION['perms'])) {
        $_SESSION['perms'] = get_perms();
    }
    foreach ($perms as $perm) {
        if (!in_array($perm, $_SESSION['perms'], true)) {
            return false;
        }
    }
    return true;
}

function add_perm($uid, $perm) {
    global $db;
    $db->insert('perms', [
        'uid' => $uid,
        'perm' => $perm,
    ]);
}

function add_tmp_perms(...$perms) {
    $_SESSION['perms'] = array_merge($_SESSION['perms'] ?? [], $perms);
}

function rm_tmp_perms(...$perms) {
    $_SESSION['perms'] = array_diff($_SESSION['perms'] ?? [], $perms);
}
