import GlobalKit as gk
import random as rand

def alphabets(seed=42, shuffle=20):
    letter = list(gk.swedish.full_uppercase)
    part = letter[:shuffle]
    rest = letter[shuffle:]
    rand.seed(seed)
    rand.shuffle(part)
    return part+rest

def chop():
    alpha = []
    alpha.append(alphabets(seed=123, shuffle=20))
    alpha.append(alphabets(seed=456, shuffle=20))
    alpha.append(alpha[0])
    return alpha

CHOP = chop()
A = 14
B = 5

def transform(ch, pos):
    if pos < 5:
        alphabet = CHOP[0]
    elif pos < 10:
        alphabet = CHOP[1]
    else:
        alphabet = CHOP[2]
    if ch not in alphabet:
        return ch
    idx = alphabet.index(ch)
    norm = idx % (29-3)
    val = (A * norm + B) % (29-3)
    return alphabet[val]

def encode(text):
    return "".join(transform(c, i) for i, c in enumerate(text))

if __name__ == "__main__":
    flag = "FAKE_FLAG"
    cipher = encode(flag)
    print("Ciphertext:", cipher)
